local assets=
{
	Asset("ANIM", "anim/shidao.zip"),
	Asset("ATLAS", "images/inventoryimages/shidao.xml"),
	Asset( "ATLAS", "images/astwidgets/ast_0.xml" )
}
local isDropped,isWeared
local function saniup(inst)
	if inst.isWeared 
	then
		inst.components.equippable.dapperness = .1
	end
end

local function onequip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "shidao", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
		inst.isWeared = true
		inst.isDropped = false
		saniup(inst)
end

local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
		
		inst.isWeared = false
		inst.isDropped = false
		saniup(inst)
end
local function ondrop(inst)
	inst.isDropped = true
	inst.isWeared = false
	saniup(inst)
end

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	inst.entity:AddNetwork()
    
    inst:AddTag("hat")
    
	inst.isWeared = false
	inst.isDropped = false
	
    anim:SetBank("shidao")
    anim:SetBuild("shidao")
    anim:PlayAnimation("idle")    
        
    inst:AddComponent("inspectable")

	if not TheWorld.ismastersim then
        return inst
    end
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/shidao.xml"
    
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
        inst:AddComponent("talker")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	inst.components.inventoryitem:SetOnDroppedFn( ondrop )
		inst.components.inventoryitem.onputininventoryfn = function(inst, player)
		local owner = inst.components.inventoryitem:GetGrandOwner()
		if player.components.inventory and player.prefab ~= "tobiichiorigami" then 
			inst:DoTaskInTime(0.1, function()
			
			player.components.inventory:DropItem(inst)
			inst.components.talker:Say("我不是鸢一折纸")
			end)
		--If it's in a container		
		elseif player.components.container and owner.prefab ~= "tobiichiorigami" then 
			inst:DoTaskInTime(0.1, function()
			
			player.components.container:DropItem(inst)
			inst.components.talker:Say("我塞不进包里")
			end)
		end
	end

	inst:ListenForEvent("phasechanged", function() saniup(inst) end, TheWorld)



return inst
end
return Prefab( "shidao", fn, assets) 
